#!/usr/bin/env python3
# -*- coding: utf-8 -*-

#
# SPDX-License-Identifier: GPL-3.0
#
# GNU Radio Python Flow Graph
# Title: IEEE 802.15.4 868 MHz BPSK TX JX
# Author: missy
# GNU Radio version: 3.10.10.0-rc1

from PyQt5 import Qt
from gnuradio import qtgui
from gnuradio import blocks
from gnuradio import digital
from gnuradio import gr
from gnuradio.filter import firdes
from gnuradio.fft import window
import sys
import signal
from PyQt5 import Qt
from argparse import ArgumentParser
from gnuradio.eng_arg import eng_float, intx
from gnuradio import eng_notation
from gnuradio import gr, pdu
from gnuradio import uhd
import time
import Ieee802154_868_tx_jx_epy_block_0_0 as epy_block_0_0  # embedded python block
import Ieee802154_868_tx_jx_epy_block_1 as epy_block_1  # embedded python block
import foo
import pmt
import ieee802_15_4



class Ieee802154_868_tx_jx(gr.top_block, Qt.QWidget):

    def __init__(self):
        gr.top_block.__init__(self, "IEEE 802.15.4 868 MHz BPSK TX JX", catch_exceptions=True)
        Qt.QWidget.__init__(self)
        self.setWindowTitle("IEEE 802.15.4 868 MHz BPSK TX JX")
        qtgui.util.check_set_qss()
        try:
            self.setWindowIcon(Qt.QIcon.fromTheme('gnuradio-grc'))
        except BaseException as exc:
            print(f"Qt GUI: Could not set Icon: {str(exc)}", file=sys.stderr)
        self.top_scroll_layout = Qt.QVBoxLayout()
        self.setLayout(self.top_scroll_layout)
        self.top_scroll = Qt.QScrollArea()
        self.top_scroll.setFrameStyle(Qt.QFrame.NoFrame)
        self.top_scroll_layout.addWidget(self.top_scroll)
        self.top_scroll.setWidgetResizable(True)
        self.top_widget = Qt.QWidget()
        self.top_scroll.setWidget(self.top_widget)
        self.top_layout = Qt.QVBoxLayout(self.top_widget)
        self.top_grid_layout = Qt.QGridLayout()
        self.top_layout.addLayout(self.top_grid_layout)

        self.settings = Qt.QSettings("GNU Radio", "Ieee802154_868_tx_jx")

        try:
            geometry = self.settings.value("geometry")
            if geometry:
                self.restoreGeometry(geometry)
        except BaseException as exc:
            print(f"Qt GUI: Could not restore geometry: {str(exc)}", file=sys.stderr)

        ##################################################
        # Variables
        ##################################################
        self.symbol_rate = symbol_rate = 300000
        self.samples_per_symbol = samples_per_symbol = 1<<3
        self.tx_gain = tx_gain = 35+5*0
        self.spreading_factor = spreading_factor = 15
        self.samp_rate = samp_rate = samples_per_symbol*symbol_rate
        self.padded_msg_len = padded_msg_len = 40
        self.num_taps = num_taps = 11*samples_per_symbol
        self.num_msgs = num_msgs = 9
        self.jx_gain = jx_gain = 35+5*3
        self.jam_delay = jam_delay = 7*8*15*samples_per_symbol
        self.excess_bw = excess_bw = 1
        self.channel_bandwidth = channel_bandwidth = min(0, 0.6e6)
        self.carrier_freq = carrier_freq = 868.3e6
        self.bpsk = bpsk = digital.constellation_bpsk().base()
        self.bpsk.set_npwr(1)

        ##################################################
        # Blocks
        ##################################################

        self.uhd_usrp_sink_0_1 = uhd.usrp_sink(
            ",".join(('', "master_clock_rate=19.2e6")),
            uhd.stream_args(
                cpu_format="fc32",
                args='',
                channels=list(range(0,2)),
            ),
            'packet_len',
        )
        self.uhd_usrp_sink_0_1.set_subdev_spec('A:A A:B', 0)
        self.uhd_usrp_sink_0_1.set_samp_rate(samp_rate)
        # No synchronization enforced.

        self.uhd_usrp_sink_0_1.set_center_freq(carrier_freq, 0)
        self.uhd_usrp_sink_0_1.set_antenna("TX/RX", 0)
        self.uhd_usrp_sink_0_1.set_gain(tx_gain, 0)

        self.uhd_usrp_sink_0_1.set_center_freq(carrier_freq, 1)
        self.uhd_usrp_sink_0_1.set_antenna("TX/RX", 1)
        self.uhd_usrp_sink_0_1.set_gain(jx_gain, 1)
        self.pdu_pdu_to_tagged_stream_0 = pdu.pdu_to_tagged_stream(gr.types.byte_t, 'packet_len')
        self.ieee802_15_4_rime_stack_0 = ieee802_15_4.rime_stack([129], [131], [132], [23,42])
        self.ieee802_15_4_mac_0 = ieee802_15_4.mac(True,0x8841,0xff,0x1aaa,0xffff,0xaffe)
        self.ieee802_15_4_access_code_prefixer_0 = ieee802_15_4.access_code_prefixer(0x00,0x000000e5)
        self.foo_periodic_msg_source_0_0 = foo.periodic_msg_source(pmt.intern("337337337337"), 250, num_msgs, True, False)
        self.foo_pad_tagged_stream_0_0 = foo.pad_tagged_stream(padded_msg_len, 'packet_len')
        self.foo_pad_tagged_stream_0_0.set_min_output_buffer(40)
        self.foo_pad_tagged_stream_0 = foo.pad_tagged_stream((padded_msg_len*8*spreading_factor*samples_per_symbol), "packet_len")
        self.epy_block_1 = epy_block_1.blk(delay_by_samples=jam_delay, jam_length_tag="jam_len", send_length_tag="packet_len")
        self.epy_block_1.set_min_output_buffer(1<<15)
        self.epy_block_0_0 = epy_block_0_0.blk(no_of_bits=8*15*8, length_tag="packet_len", jam_length_tag="jam_len", jamming_enabled=True)
        self.digital_diff_encoder_bb_0 = digital.diff_encoder_bb(2, digital.DIFF_DIFFERENTIAL)
        self.digital_constellation_modulator_0_0 = digital.generic_mod(
            constellation=bpsk,
            differential=False,
            samples_per_symbol=samples_per_symbol,
            pre_diff_code=True,
            excess_bw=excess_bw,
            verbose=True,
            log=False,
            truncate=False)
        self.digital_constellation_modulator_0 = digital.generic_mod(
            constellation=bpsk,
            differential=False,
            samples_per_symbol=samples_per_symbol,
            pre_diff_code=True,
            excess_bw=excess_bw,
            verbose=True,
            log=False,
            truncate=False)
        self.digital_chunks_to_symbols_xx_0_0 = digital.chunks_to_symbols_bf([1,1,1,1,0,1,0,1,1,0,0,1,0,0,0,  0,0,0,0,1,0,1,0,0,1,1,0,1,1,1], 15)
        self.blocks_uchar_to_float_1 = blocks.uchar_to_float()
        self.blocks_tagged_stream_multiply_length_0_0 = blocks.tagged_stream_multiply_length(gr.sizeof_gr_complex*1, 'jam_len', samples_per_symbol)
        self.blocks_tagged_stream_multiply_length_0 = blocks.tagged_stream_multiply_length(gr.sizeof_gr_complex*1, 'packet_len', (8*spreading_factor*samples_per_symbol))
        self.blocks_packed_to_unpacked_xx_0 = blocks.packed_to_unpacked_bb(1, gr.GR_LSB_FIRST)
        self.blocks_pack_k_bits_bb_0_0 = blocks.pack_k_bits_bb(8)
        self.blocks_pack_k_bits_bb_0 = blocks.pack_k_bits_bb(8)
        self.blocks_float_to_uchar_0 = blocks.float_to_uchar(1, 1, 0)
        self.blocks_float_to_complex_1 = blocks.float_to_complex(1)
        self.blocks_float_to_char_0 = blocks.float_to_char(1, 1)
        self.blocks_complex_to_float_1 = blocks.complex_to_float(1)


        ##################################################
        # Connections
        ##################################################
        self.msg_connect((self.foo_periodic_msg_source_0_0, 'out'), (self.ieee802_15_4_rime_stack_0, 'bcin'))
        self.msg_connect((self.ieee802_15_4_access_code_prefixer_0, 'out'), (self.pdu_pdu_to_tagged_stream_0, 'pdus'))
        self.msg_connect((self.ieee802_15_4_mac_0, 'pdu out'), (self.ieee802_15_4_access_code_prefixer_0, 'in'))
        self.msg_connect((self.ieee802_15_4_mac_0, 'app out'), (self.ieee802_15_4_rime_stack_0, 'fromMAC'))
        self.msg_connect((self.ieee802_15_4_rime_stack_0, 'toMAC'), (self.ieee802_15_4_mac_0, 'app in'))
        self.connect((self.blocks_complex_to_float_1, 0), (self.blocks_float_to_uchar_0, 0))
        self.connect((self.blocks_float_to_char_0, 0), (self.blocks_pack_k_bits_bb_0, 0))
        self.connect((self.blocks_float_to_char_0, 0), (self.epy_block_0_0, 0))
        self.connect((self.blocks_float_to_complex_1, 0), (self.foo_pad_tagged_stream_0_0, 0))
        self.connect((self.blocks_float_to_uchar_0, 0), (self.blocks_packed_to_unpacked_xx_0, 0))
        self.connect((self.blocks_pack_k_bits_bb_0, 0), (self.digital_constellation_modulator_0, 0))
        self.connect((self.blocks_pack_k_bits_bb_0_0, 0), (self.digital_constellation_modulator_0_0, 0))
        self.connect((self.blocks_packed_to_unpacked_xx_0, 0), (self.digital_diff_encoder_bb_0, 0))
        self.connect((self.blocks_tagged_stream_multiply_length_0, 0), (self.uhd_usrp_sink_0_1, 0))
        self.connect((self.blocks_tagged_stream_multiply_length_0_0, 0), (self.epy_block_1, 0))
        self.connect((self.blocks_uchar_to_float_1, 0), (self.blocks_float_to_complex_1, 0))
        self.connect((self.digital_chunks_to_symbols_xx_0_0, 0), (self.blocks_float_to_char_0, 0))
        self.connect((self.digital_constellation_modulator_0, 0), (self.blocks_tagged_stream_multiply_length_0, 0))
        self.connect((self.digital_constellation_modulator_0_0, 0), (self.blocks_tagged_stream_multiply_length_0_0, 0))
        self.connect((self.digital_diff_encoder_bb_0, 0), (self.digital_chunks_to_symbols_xx_0_0, 0))
        self.connect((self.epy_block_0_0, 0), (self.blocks_pack_k_bits_bb_0_0, 0))
        self.connect((self.epy_block_1, 0), (self.foo_pad_tagged_stream_0, 0))
        self.connect((self.foo_pad_tagged_stream_0, 0), (self.uhd_usrp_sink_0_1, 1))
        self.connect((self.foo_pad_tagged_stream_0_0, 0), (self.blocks_complex_to_float_1, 0))
        self.connect((self.pdu_pdu_to_tagged_stream_0, 0), (self.blocks_uchar_to_float_1, 0))


    def closeEvent(self, event):
        self.settings = Qt.QSettings("GNU Radio", "Ieee802154_868_tx_jx")
        self.settings.setValue("geometry", self.saveGeometry())
        self.stop()
        self.wait()

        event.accept()

    def get_symbol_rate(self):
        return self.symbol_rate

    def set_symbol_rate(self, symbol_rate):
        self.symbol_rate = symbol_rate
        self.set_samp_rate(self.samples_per_symbol*self.symbol_rate)

    def get_samples_per_symbol(self):
        return self.samples_per_symbol

    def set_samples_per_symbol(self, samples_per_symbol):
        self.samples_per_symbol = samples_per_symbol
        self.set_jam_delay(7*8*15*self.samples_per_symbol)
        self.set_num_taps(11*self.samples_per_symbol)
        self.set_samp_rate(self.samples_per_symbol*self.symbol_rate)
        self.blocks_tagged_stream_multiply_length_0.set_scalar((8*self.spreading_factor*self.samples_per_symbol))
        self.blocks_tagged_stream_multiply_length_0_0.set_scalar(self.samples_per_symbol)

    def get_tx_gain(self):
        return self.tx_gain

    def set_tx_gain(self, tx_gain):
        self.tx_gain = tx_gain
        self.uhd_usrp_sink_0_1.set_gain(self.tx_gain, 0)

    def get_spreading_factor(self):
        return self.spreading_factor

    def set_spreading_factor(self, spreading_factor):
        self.spreading_factor = spreading_factor
        self.blocks_tagged_stream_multiply_length_0.set_scalar((8*self.spreading_factor*self.samples_per_symbol))

    def get_samp_rate(self):
        return self.samp_rate

    def set_samp_rate(self, samp_rate):
        self.samp_rate = samp_rate
        self.uhd_usrp_sink_0_1.set_samp_rate(self.samp_rate)

    def get_padded_msg_len(self):
        return self.padded_msg_len

    def set_padded_msg_len(self, padded_msg_len):
        self.padded_msg_len = padded_msg_len

    def get_num_taps(self):
        return self.num_taps

    def set_num_taps(self, num_taps):
        self.num_taps = num_taps

    def get_num_msgs(self):
        return self.num_msgs

    def set_num_msgs(self, num_msgs):
        self.num_msgs = num_msgs

    def get_jx_gain(self):
        return self.jx_gain

    def set_jx_gain(self, jx_gain):
        self.jx_gain = jx_gain
        self.uhd_usrp_sink_0_1.set_gain(self.jx_gain, 1)

    def get_jam_delay(self):
        return self.jam_delay

    def set_jam_delay(self, jam_delay):
        self.jam_delay = jam_delay
        self.epy_block_1.delay_by_samples = self.jam_delay

    def get_excess_bw(self):
        return self.excess_bw

    def set_excess_bw(self, excess_bw):
        self.excess_bw = excess_bw

    def get_channel_bandwidth(self):
        return self.channel_bandwidth

    def set_channel_bandwidth(self, channel_bandwidth):
        self.channel_bandwidth = channel_bandwidth
        self.uhd_usrp_sink_0_1.set_bandwidth(self.channel_bandwidth, 0)
        self.uhd_usrp_sink_0_1.set_bandwidth(self.channel_bandwidth, 1)

    def get_carrier_freq(self):
        return self.carrier_freq

    def set_carrier_freq(self, carrier_freq):
        self.carrier_freq = carrier_freq
        self.uhd_usrp_sink_0_1.set_center_freq(self.carrier_freq, 0)
        self.uhd_usrp_sink_0_1.set_center_freq(self.carrier_freq, 1)

    def get_bpsk(self):
        return self.bpsk

    def set_bpsk(self, bpsk):
        self.bpsk = bpsk




def main(top_block_cls=Ieee802154_868_tx_jx, options=None):
    if gr.enable_realtime_scheduling() != gr.RT_OK:
        gr.logger("realtime").warn("Error: failed to enable real-time scheduling.")

    qapp = Qt.QApplication(sys.argv)

    tb = top_block_cls()

    tb.start()

    tb.show()

    def sig_handler(sig=None, frame=None):
        tb.stop()
        tb.wait()

        Qt.QApplication.quit()

    signal.signal(signal.SIGINT, sig_handler)
    signal.signal(signal.SIGTERM, sig_handler)

    timer = Qt.QTimer()
    timer.start(500)
    timer.timeout.connect(lambda: None)

    qapp.exec_()

if __name__ == '__main__':
    main()
