#!/usr/bin/env python3
# -*- coding: utf-8 -*-

#
# SPDX-License-Identifier: GPL-3.0
#
# GNU Radio Python Flow Graph
# Title: IEEE 802.15.4 868 MHz BPSK RX
# Author: missy
# GNU Radio version: 3.10.10.0-rc1

from datetime import date, time, datetime, timezone
from gnuradio import blocks
from gnuradio import digital
from gnuradio import filter
from gnuradio.filter import firdes
from gnuradio import gr
from gnuradio.fft import window
import sys
import signal
from argparse import ArgumentParser
from gnuradio.eng_arg import eng_float, intx
from gnuradio import eng_notation
from gnuradio import gr, pdu
from gnuradio import uhd
import time
import Ieee802154_868_rx_epy_block_0_0 as epy_block_0_0  # embedded python block
import Ieee802154_868_rx_epy_block_0_1 as epy_block_0_1  # embedded python block
import foo
import ieee802_15_4




class Ieee802154_868_rx(gr.top_block):

    def __init__(self):
        gr.top_block.__init__(self, "IEEE 802.15.4 868 MHz BPSK RX", catch_exceptions=True)

        ##################################################
        # Variables
        ##################################################
        self.samples_per_symbol = samples_per_symbol = 4
        self.symbol_rate = symbol_rate = 300000*samples_per_symbol
        self.rx_over_sampling_rate = rx_over_sampling_rate = 4>>2
        self.date_time = date_time = datetime.now().strftime("%Y-%m-%d-%H%M%S")
        self.counter = counter = 3501601
        self.samp_rate = samp_rate = samples_per_symbol*symbol_rate*rx_over_sampling_rate
        self.raw_file_suffix = raw_file_suffix = "-raw.bin"
        self.pcap_file_suffix = pcap_file_suffix = ".pcap"
        self.path_prefix = path_prefix = "/home/kali/Downloads/grc/rx/"+date_time+"-"+str(counter)
        self.spreading_factor = spreading_factor = 15
        self.rx_gain = rx_gain = 60
        self.phase_bw = phase_bw = 0.2513272/4
        self.pcap_file = pcap_file = path_prefix+pcap_file_suffix
        self.num_taps = num_taps = int(11*samp_rate/3e5)
        self.excess_bw = excess_bw = 1
        self.dsss_access_code_partial_inverted = dsss_access_code_partial_inverted = "000010100110111000010100110111000010100110111000010100110111"
        self.dsss_access_code_partial = dsss_access_code_partial = "111101011001000111101011001000111101011001000111101011001000"
        self.cl_file = cl_file = path_prefix+"-cl"+raw_file_suffix
        self.channel_bandwidth = channel_bandwidth = min(0, 0.6e6)
        self.carrier_freq = carrier_freq = 868.3e6
        self.bpsk = bpsk = digital.constellation_bpsk().base()
        self.bpsk.set_npwr(1)
        self.bpsk.gen_soft_dec_lut(8)
        self.arity = arity = 2

        ##################################################
        # Blocks
        ##################################################

        self.uhd_usrp_source_0 = uhd.usrp_source(
            ",".join(('', '')),
            uhd.stream_args(
                cpu_format="fc32",
                args='',
                channels=list(range(0,1)),
            ),
        )
        self.uhd_usrp_source_0.set_samp_rate(samp_rate)
        # No synchronization enforced.

        self.uhd_usrp_source_0.set_center_freq(carrier_freq, 0)
        self.uhd_usrp_source_0.set_antenna("TX/RX", 0)
        self.uhd_usrp_source_0.set_rx_agc(False, 0)
        self.uhd_usrp_source_0.set_gain(rx_gain, 0)
        self.uhd_usrp_source_0.set_auto_dc_offset(True, 0)
        self.uhd_usrp_source_0.set_auto_iq_balance(True, 0)
        self.root_raised_cosine_filter_0_0_0_0 = filter.fir_filter_ccf(
            1,
            firdes.root_raised_cosine(
                1,
                samp_rate,
                symbol_rate>>1,
                excess_bw,
                num_taps))
        self.pdu_tagged_stream_to_pdu_0 = pdu.tagged_stream_to_pdu(gr.types.byte_t, "packet_len")
        self.ieee802_15_4_codeword_demapper_ib_1 = ieee802_15_4.codeword_demapper_ib(1, [[1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0], [0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1]])
        self.foo_wireshark_connector_0_1 = foo.wireshark_connector(195, False)
        self.epy_block_0_1 = epy_block_0_1.blk(spreading_factor=spreading_factor, mtu=127>>1, dsss_access_code_length=60, dsss_phr_length=6*8*spreading_factor)
        self.epy_block_0_1.set_min_output_buffer((2**13))
        self.epy_block_0_0 = epy_block_0_0.blk(phr_len_bytes=6, packet_len_tag="packet_len", mtu=127, sfd=0xe5, lossyAccept=1)
        self.digital_symbol_sync_xx_0 = digital.symbol_sync_cc(
            digital.TED_EARLY_LATE,
            samples_per_symbol<<2,
            phase_bw,
            1.0,
            .5,
            1.50,
            1,
            digital.constellation_bpsk().base(),
            digital.IR_MMSE_8TAP,
            128,
            [])
        self.digital_map_bb_0 = digital.map_bb([0,1])
        self.digital_fll_band_edge_cc_0 = digital.fll_band_edge_cc((int(samples_per_symbol*samp_rate/symbol_rate)), excess_bw, (2*int(samples_per_symbol*samp_rate/symbol_rate)+1), (2*3.14159*0.01/int(samples_per_symbol*samp_rate/symbol_rate)))
        self.digital_diff_decoder_bb_1 = digital.diff_decoder_bb(2, digital.DIFF_DIFFERENTIAL)
        self.digital_costas_loop_cc_0 = digital.costas_loop_cc((phase_bw*1.0), arity, False)
        self.digital_correlate_access_code_tag_xx_0_0 = digital.correlate_access_code_tag_bb(dsss_access_code_partial_inverted, (int(4*0.5)*2<<1), "soiphr")
        self.digital_correlate_access_code_tag_xx_0_0.set_min_output_buffer((2**13))
        self.digital_correlate_access_code_tag_xx_0 = digital.correlate_access_code_tag_bb(dsss_access_code_partial, (int(4*0.5)*2<<1), "sophr")
        self.digital_correlate_access_code_tag_xx_0.set_min_output_buffer((2**13))
        self.digital_constellation_decoder_cb_1 = digital.constellation_decoder_cb(bpsk)
        self.blocks_tag_gate_0_0_0 = blocks.tag_gate(gr.sizeof_char * 1, False)
        self.blocks_tag_gate_0_0_0.set_single_key("")
        self.blocks_repack_bits_bb_0 = blocks.repack_bits_bb(1, 8, "", False, gr.GR_LSB_FIRST)
        self.blocks_float_to_int_1 = blocks.float_to_int(1, 1)
        self.blocks_float_to_complex_0 = blocks.float_to_complex(1)
        self.blocks_file_sink_1_0_0 = blocks.file_sink(gr.sizeof_gr_complex*1, cl_file, False)
        self.blocks_file_sink_1_0_0.set_unbuffered(True)
        self.blocks_file_sink_0_0 = blocks.file_sink(gr.sizeof_char*1, pcap_file, False)
        self.blocks_file_sink_0_0.set_unbuffered(True)
        self.blocks_complex_to_float_0 = blocks.complex_to_float(1)
        self.blocks_char_to_float_2 = blocks.char_to_float(1, 1)


        ##################################################
        # Connections
        ##################################################
        self.msg_connect((self.pdu_tagged_stream_to_pdu_0, 'pdus'), (self.foo_wireshark_connector_0_1, 'in'))
        self.connect((self.blocks_char_to_float_2, 0), (self.blocks_float_to_int_1, 0))
        self.connect((self.blocks_complex_to_float_0, 0), (self.blocks_float_to_complex_0, 0))
        self.connect((self.blocks_float_to_complex_0, 0), (self.digital_constellation_decoder_cb_1, 0))
        self.connect((self.blocks_float_to_int_1, 0), (self.ieee802_15_4_codeword_demapper_ib_1, 0))
        self.connect((self.blocks_repack_bits_bb_0, 0), (self.epy_block_0_0, 0))
        self.connect((self.blocks_tag_gate_0_0_0, 0), (self.digital_correlate_access_code_tag_xx_0, 0))
        self.connect((self.digital_constellation_decoder_cb_1, 0), (self.digital_map_bb_0, 0))
        self.connect((self.digital_correlate_access_code_tag_xx_0, 0), (self.digital_correlate_access_code_tag_xx_0_0, 0))
        self.connect((self.digital_correlate_access_code_tag_xx_0_0, 0), (self.epy_block_0_1, 0))
        self.connect((self.digital_costas_loop_cc_0, 0), (self.blocks_complex_to_float_0, 0))
        self.connect((self.digital_costas_loop_cc_0, 0), (self.blocks_file_sink_1_0_0, 0))
        self.connect((self.digital_diff_decoder_bb_1, 0), (self.blocks_repack_bits_bb_0, 0))
        self.connect((self.digital_fll_band_edge_cc_0, 0), (self.root_raised_cosine_filter_0_0_0_0, 0))
        self.connect((self.digital_map_bb_0, 0), (self.blocks_tag_gate_0_0_0, 0))
        self.connect((self.digital_symbol_sync_xx_0, 0), (self.digital_costas_loop_cc_0, 0))
        self.connect((self.epy_block_0_0, 0), (self.pdu_tagged_stream_to_pdu_0, 0))
        self.connect((self.epy_block_0_1, 0), (self.blocks_char_to_float_2, 0))
        self.connect((self.foo_wireshark_connector_0_1, 0), (self.blocks_file_sink_0_0, 0))
        self.connect((self.ieee802_15_4_codeword_demapper_ib_1, 0), (self.digital_diff_decoder_bb_1, 0))
        self.connect((self.root_raised_cosine_filter_0_0_0_0, 0), (self.digital_symbol_sync_xx_0, 0))
        self.connect((self.uhd_usrp_source_0, 0), (self.digital_fll_band_edge_cc_0, 0))


    def get_samples_per_symbol(self):
        return self.samples_per_symbol

    def set_samples_per_symbol(self, samples_per_symbol):
        self.samples_per_symbol = samples_per_symbol
        self.set_samp_rate(self.samples_per_symbol*self.symbol_rate*self.rx_over_sampling_rate)
        self.set_symbol_rate(300000*self.samples_per_symbol)
        self.digital_fll_band_edge_cc_0.set_loop_bandwidth((2*3.14159*0.01/int(self.samples_per_symbol*self.samp_rate/self.symbol_rate)))
        self.digital_symbol_sync_xx_0.set_sps(self.samples_per_symbol<<2)

    def get_symbol_rate(self):
        return self.symbol_rate

    def set_symbol_rate(self, symbol_rate):
        self.symbol_rate = symbol_rate
        self.set_samp_rate(self.samples_per_symbol*self.symbol_rate*self.rx_over_sampling_rate)
        self.digital_fll_band_edge_cc_0.set_loop_bandwidth((2*3.14159*0.01/int(self.samples_per_symbol*self.samp_rate/self.symbol_rate)))
        self.root_raised_cosine_filter_0_0_0_0.set_taps(firdes.root_raised_cosine(1, self.samp_rate, self.symbol_rate>>1, self.excess_bw, self.num_taps))

    def get_rx_over_sampling_rate(self):
        return self.rx_over_sampling_rate

    def set_rx_over_sampling_rate(self, rx_over_sampling_rate):
        self.rx_over_sampling_rate = rx_over_sampling_rate
        self.set_samp_rate(self.samples_per_symbol*self.symbol_rate*self.rx_over_sampling_rate)

    def get_date_time(self):
        return self.date_time

    def set_date_time(self, date_time):
        self.date_time = date_time
        self.set_path_prefix("/home/kali/Downloads/grc/rx/"+self.date_time+"-"+str(self.counter))

    def get_counter(self):
        return self.counter

    def set_counter(self, counter):
        self.counter = counter
        self.set_path_prefix("/home/kali/Downloads/grc/rx/"+self.date_time+"-"+str(self.counter))

    def get_samp_rate(self):
        return self.samp_rate

    def set_samp_rate(self, samp_rate):
        self.samp_rate = samp_rate
        self.set_num_taps(int(11*self.samp_rate/3e5))
        self.digital_fll_band_edge_cc_0.set_loop_bandwidth((2*3.14159*0.01/int(self.samples_per_symbol*self.samp_rate/self.symbol_rate)))
        self.root_raised_cosine_filter_0_0_0_0.set_taps(firdes.root_raised_cosine(1, self.samp_rate, self.symbol_rate>>1, self.excess_bw, self.num_taps))
        self.uhd_usrp_source_0.set_samp_rate(self.samp_rate)

    def get_raw_file_suffix(self):
        return self.raw_file_suffix

    def set_raw_file_suffix(self, raw_file_suffix):
        self.raw_file_suffix = raw_file_suffix
        self.set_cl_file(self.path_prefix+"-cl"+self.raw_file_suffix)

    def get_pcap_file_suffix(self):
        return self.pcap_file_suffix

    def set_pcap_file_suffix(self, pcap_file_suffix):
        self.pcap_file_suffix = pcap_file_suffix
        self.set_pcap_file(self.path_prefix+self.pcap_file_suffix)

    def get_path_prefix(self):
        return self.path_prefix

    def set_path_prefix(self, path_prefix):
        self.path_prefix = path_prefix
        self.set_cl_file(self.path_prefix+"-cl"+self.raw_file_suffix)
        self.set_pcap_file(self.path_prefix+self.pcap_file_suffix)

    def get_spreading_factor(self):
        return self.spreading_factor

    def set_spreading_factor(self, spreading_factor):
        self.spreading_factor = spreading_factor
        self.epy_block_0_1.dsss_phr_length = 6*8*self.spreading_factor
        self.epy_block_0_1.spreading_factor = self.spreading_factor

    def get_rx_gain(self):
        return self.rx_gain

    def set_rx_gain(self, rx_gain):
        self.rx_gain = rx_gain
        self.uhd_usrp_source_0.set_gain(self.rx_gain, 0)

    def get_phase_bw(self):
        return self.phase_bw

    def set_phase_bw(self, phase_bw):
        self.phase_bw = phase_bw
        self.digital_costas_loop_cc_0.set_loop_bandwidth((self.phase_bw*1.0))
        self.digital_symbol_sync_xx_0.set_loop_bandwidth(self.phase_bw)

    def get_pcap_file(self):
        return self.pcap_file

    def set_pcap_file(self, pcap_file):
        self.pcap_file = pcap_file
        self.blocks_file_sink_0_0.open(self.pcap_file)

    def get_num_taps(self):
        return self.num_taps

    def set_num_taps(self, num_taps):
        self.num_taps = num_taps
        self.root_raised_cosine_filter_0_0_0_0.set_taps(firdes.root_raised_cosine(1, self.samp_rate, self.symbol_rate>>1, self.excess_bw, self.num_taps))

    def get_excess_bw(self):
        return self.excess_bw

    def set_excess_bw(self, excess_bw):
        self.excess_bw = excess_bw
        self.root_raised_cosine_filter_0_0_0_0.set_taps(firdes.root_raised_cosine(1, self.samp_rate, self.symbol_rate>>1, self.excess_bw, self.num_taps))

    def get_dsss_access_code_partial_inverted(self):
        return self.dsss_access_code_partial_inverted

    def set_dsss_access_code_partial_inverted(self, dsss_access_code_partial_inverted):
        self.dsss_access_code_partial_inverted = dsss_access_code_partial_inverted
        self.digital_correlate_access_code_tag_xx_0_0.set_access_code(self.dsss_access_code_partial_inverted)

    def get_dsss_access_code_partial(self):
        return self.dsss_access_code_partial

    def set_dsss_access_code_partial(self, dsss_access_code_partial):
        self.dsss_access_code_partial = dsss_access_code_partial
        self.digital_correlate_access_code_tag_xx_0.set_access_code(self.dsss_access_code_partial)

    def get_cl_file(self):
        return self.cl_file

    def set_cl_file(self, cl_file):
        self.cl_file = cl_file
        self.blocks_file_sink_1_0_0.open(self.cl_file)

    def get_channel_bandwidth(self):
        return self.channel_bandwidth

    def set_channel_bandwidth(self, channel_bandwidth):
        self.channel_bandwidth = channel_bandwidth
        self.uhd_usrp_source_0.set_bandwidth(self.channel_bandwidth, 0)

    def get_carrier_freq(self):
        return self.carrier_freq

    def set_carrier_freq(self, carrier_freq):
        self.carrier_freq = carrier_freq
        self.uhd_usrp_source_0.set_center_freq(self.carrier_freq, 0)

    def get_bpsk(self):
        return self.bpsk

    def set_bpsk(self, bpsk):
        self.bpsk = bpsk
        self.digital_constellation_decoder_cb_1.set_constellation(self.bpsk)

    def get_arity(self):
        return self.arity

    def set_arity(self, arity):
        self.arity = arity




def main(top_block_cls=Ieee802154_868_rx, options=None):
    if gr.enable_realtime_scheduling() != gr.RT_OK:
        gr.logger("realtime").warn("Error: failed to enable real-time scheduling.")
    tb = top_block_cls()

    def sig_handler(sig=None, frame=None):
        tb.stop()
        tb.wait()

        sys.exit(0)

    signal.signal(signal.SIGINT, sig_handler)
    signal.signal(signal.SIGTERM, sig_handler)

    tb.start()

    try:
        input('Press Enter to quit: ')
    except EOFError:
        pass
    tb.stop()
    tb.wait()


if __name__ == '__main__':
    main()
